********************************************************************************
**************************** ICD-10 code lists *********************************
******************************* Chapter 3.4  ***********************************

*     Open log
log using "My file path:\...\CPRD_CodeBrowser_202211_Aurum\CPRD_CodeBrowser_202211_Aurum\Logs\nameoflog"


***************** Step 1: Import Codes and Titles .txt file ********************
*     Note: The file downloaded from NHS TRUD is a compressed zip file, this needs to be extracted by clicking 'Extract all' once opening the .zip folder.
*     Once opened, we want to open the 'Content' folder and import the Codes And Titles and Metadata .txt file.

import delimited "My file path:\...\codes\icd-10\icd_df_10.5.0_20151102000001\ICD10_Edition5_20160401\Content\ICD10_Edition5_CodesAndTitlesAndMetadata_GB_20160401.txt", bindquote(nobind) stringcols(4 6 9 10 11)




***************** Step 2: Generate lowercase variables *************************
*     Similar to code searching using the Medical/Product .txt file from CPRD Aurum.

gen description_lower = ustrlower(description)




***************** Step 3: Searching for inclusion terms ************************
*     We want to generate a new variable 'poss_fracture' that is 1 if the description matches the term 'fracture', and missing otherwise.

gen poss_fracture = .
replace poss_fracture = 1 if strmatch(description_lower, "*fracture*")

*     Keeping only fracture codes
keep if poss_fracture==1




***************** Step 4: Searching for exclusion terms ************************
*     We want to generate a new variable 'exclude' that can distinguish the exclusion terms from the rest.
*     It is beneficial to browse the term prior to excluding it as there may be 0 matches.

gen exclude =.
browse if strmatch(description_lower, "*tooth*")
replace exclude = 1 if strmatch(description_lower, "*tooth*")

browse if strmatch(description_lower, "*birth*")
replace exclude = 1 if strmatch(description_lower, "*birth*")

*     Dropping exclusion matches
drop if exclude==1



*     Save the file as a .dta



*     Close log
log close